<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>contribution- Commufy</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" defer
        integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4"
        crossorigin="anonymous"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
        integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- Remix Icon CDN -->
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css">
    <style>
        :root {
            --primary: #13ADB7;
        }

        body {
            min-height: 100vh;
            margin: 0;
            background: linear-gradient(to bottom, rgb(253, 252, 252) 40%, #eff2f2 40%);
            font-family: Arial, sans-serif, 'Franklin Gothic Medium', 'Arial Narrow';
        }

        .saisir input::placeholder {
            color: rgba(49, 51, 180, 0.5);
            opacity: 1;

        }
    </style>
</head>

<body class="fs-4">

    <div class="container">

        <!-- inserstion du montant a contribuer -->
        <div class="row">
            <div class="col-md-12 d-flex justify-content-between align-items-center ">
                <a href="index.php?action=project&id=<?php echo $projectDetails['id']; ?>"><i
                        class="fas fa-arrow-left text-primary"></i></a>
                <span class="text-dark">
                    <img src="https://ui-avatars.com/api/?name=<?php echo htmlspecialchars($_SESSION['username']); ?>&color=fff&background=0D8ABC"
                        alt="" class="img-fluid rounded-circle" style="width: 50px; height: 50px;">
                </span>
            </div>
            <div class="row ">
                <p class="text-primary text-center fs-2"><i class="ri-building-2-fill"></i>COMMUNIFY</p>
                <div class="col-md-2"></div>
                <div class="col-md-8">
                    <h2 class=" text-primary">Contribuer à la collecte de fonds</h2>
                    <p class=" text-secondary">Vous pouvez contribuer à la collecte de fonds pour le projet
                        <span
                            class="fw-bold text-success"><?php echo htmlspecialchars($projectDetails['titre']); ?></span>
                        en effectuant un don. Merci de votre générosité !
                    </p>
                    <?php
                    if (isset($_SESSION['errors'])) {
                        foreach ($_SESSION['errors'] as $error) {
                            echo '<div class="alert alert-danger text-center" style="height: auto;">' . htmlspecialchars($error) . '</div>';
                        }
                        unset($_SESSION['errors']);
                    } ?>
                </div>
                <div class="col-md-2"></div>
            </div>
        </div>

        <form action="index.php?action=contribute_process&id=<?php echo $projectDetails['id']; ?>" method="post"
            onsubmit="return confirm('Vous etes sur le point de faire un don . validez pour continuer ou annuler')">
            <div class="row">
                <div class="col-md-2"></div>
                <div class="col-md-6 my-3">
                    <!-- section des donnees -->
                    <div class="form-control">
                        <p class="fw-bold my-1">Soutenez avec un don</p>
                        <div class="justify-content-center align-items-center saisir my-2">
                            <label for="montant" class="form-label">Participez librement à la réussite de cette
                                collecte! le montant est en FCFA<span class="text-danger fw-bold">*</span></label>
                            <input type="number" class="form-control text-success" name="montant" id="montant" required
                                placeholder="saisir le montant du dons: 500, 5000, 10000">
                        </div>
                        <div class="justify-content-center align-items-center saisir my-2">
                            <label for="telephone" class="form-label w-100">Votre numéro de téléphone: <span
                                    class="text-danger fw-bold">*</span> </label>
                            <input type="tel" name="telephone" id="telephone" class="form-control w-100" maxlength="13"
                                required>
                        </div>
                        <div class="mb-3">
                            <label for="message" class="form-label">Messages(optionnel):</label>
                            <textarea class="form-control" id="messagee" name="message" rows="3"
                                placeholder="saisir votre message d'encouragement (optionnel)"></textarea>
                        </div>
                        <input type="hidden" class="form-control" name="id_projects"
                            value="<?php echo $projectDetails['id'] ?>" id="id_projects" required>
                        <p class="mt-1 w-auto">
                            Vous vous apprêtez à soutenir une collecte en franc CFA. Merci pour votre contribution !
                            En contribuant, vous acceptez les aléas liés à tout projet participatif.
                            La plateforme ne garantit pas la réussite et n’est pas responsable des engagements pris par
                            les porteurs du projet.
                        </p>
                    </div>
                </div>
                <div class="col-md-4 my-3">
                    <!-- section du mode de paiement -->
                    <div class="form-control">
                        <p class="fw-bold my-1">Sélectionnez le mode de paiement :<span
                                class="text-danger fw-bold">*</span></p>
                        <div class="d-flex flex-column gap-2">
                            <label class="d-flex align-items-center border p-2 rounded bg-warning">
                                <input type="radio" name="mode_payement" value="Orange Money" class="me-2" required>
                                <img src="/public/images/orange_money.png" alt="Orange Money" width="40" class="me-2">
                                <span>Orange Money</span>
                            </label>

                            <label class="d-flex align-items-center border p-2 rounded"
                                style="background-color: yellow;">
                                <input type="radio" name="mode_payement" value="MTN Mobile Money" class="me-2">
                                <img src="/public/images/mobile_money.png" alt="MTN Mobile Money" width="40"
                                    class="me-2">
                                <span>MTN Mobile Money</span>
                            </label>

                            <label class="d-flex align-items-center border p-2 rounded bg-primary">
                                <input type="radio" name="mode_payement" value="PayPal" class="me-2">
                                <img src="/public/images/paypal.png" alt="PayPal" width="40" class="me-2">
                                <span>PayPal</span>
                            </label>
                        </div>
                        <button type="submit" class="btn btn-primary w-100 mb-3 mt-2"
                            style="background-color: var(--primary) !important;"> Valider la contribution</button>
                        <p id="error-message"></p>
                    </div>
                </div>
            </div>
        </form>
        <div class="position-fixed bottom-0 end-0 p-3" style="z-index: 9999">
            <div id="toast-success" class="toast align-items-center text-bg-success border-0" role="alert"
                aria-live="assertive" aria-atomic="true">
                <div class="d-flex">
                    <div class="toast-body" id="toast-message">
                        <!-- Le message PHP du success de la contribution -->
                        <?php
                        if (isset($_SESSION['success'])) {
                            $msg = htmlspecialchars($_SESSION['success'], ENT_QUOTES, 'UTF-8');
                            echo "<script>
                                    window.addEventListener('DOMContentLoaded', function() {
                                        const toastEl = document.getElementById('toast-success');
                                        const toastMessage = document.getElementById('toast-message');
                                        toastMessage.innerHTML = '$msg';
                                        const toast = new bootstrap.Toast(toastEl);
                                        toast.show();
                                    });
                                </script>";
                            unset($_SESSION['success']);
                        }
                        ?>

                    </div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"
                        aria-label="Close"></button>
                </div>
            </div>
        </div>


    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"
        integrity="sha512-JobWAqYk5CSjWuVV3mxgS+MmccJqkrBaDhk8SKS1BW+71dJ9gzascwzW85UwGhxiSyR7Pxhu50k+Nl3+o5I49A=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"
        integrity="sha384-oBqDVmMz9ATKxIep9tiCxS/Z9fNfEXiDAYTujMAeBAsjFuCZSmKbSSUnQlmh/jp3"
        crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.min.js"
        integrity="sha384-cuYeSxntonz0PPNlHhBs68uyIAVpIIOZZ5JqeqvYYIcEL727kskC66kF92t6Xl2V"
        crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
    <script>
        var input = document.querySelector("#telephone");
        var iti = window.intlTelInput(input, {
            separateDialCode: true,
            preferredCountries: ["cm"],
            utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js"
        });
        const form = document.querySelector('form');
        form.addEventListener('submit', function (event) {
            const mess = document.getElementById('error-message');
            if (!iti.isValidNumber()) {
                event.preventDefault();
                mess.innerText = "Le numéro de téléphone est invalide.";
                mess.classList.add('text-danger');
            }
        });
    </script>
</body>

</html>