<?php
require_once __DIR__ . '/config/database.php';

function initializeDatabase()
{
    try {
        // Connexion sans spécifier la base (utile pour créer la DB)
        $dsn = "mysql:host=" . DB_HOST . ";port=" . DB_PORT;
        $pdo = new PDO($dsn, DB_USER, DB_PASS);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        echo "Connexion au serveur MySQL réussie.<br>";

        // Créer la base de données si elle n'existe pas
        $pdo->exec("CREATE DATABASE IF NOT EXISTS `" . DB_NAME . "` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci");
        echo "Base de données '" . DB_NAME . "' créée ou déjà existante.<br>";

        // Connexion à la base
        $pdo->exec("USE `" . DB_NAME . "`");

        // Création des tables...
        $pdo->exec("CREATE TABLE IF NOT EXISTS users (
            id INT AUTO_INCREMENT PRIMARY KEY,
            nom VARCHAR(50) NOT NULL DEFAULT users,
            email VARCHAR(255) UNIQUE NOT NULL,
            password VARCHAR(255) NOT NULL,
            role VARCHAR(10) NOT NULL DEFAULT 'user',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB");

        $pdo->exec("CREATE TABLE IF NOT EXISTS categories (
            id INT AUTO_INCREMENT PRIMARY KEY,
            nom VARCHAR(50) NOT NULL,
            description VARCHAR(255) NOT NULL
        ) ENGINE=InnoDB");

        $pdo->exec("INSERT IGNORE INTO categories (id, nom, description) VALUES
            (1, 'Art', 'Projets artistiques'),
            (2, 'Technologie', 'Innovations technologiques'),
            (3, 'Éducation', 'Projets éducatifs'),
            (4, 'Environnement', 'Projets environnementaux'),
            (5, 'Santé', 'Projets liés à la santé'),
            (6, 'Personnelle', 'Projets personnelle')
        ");

        $pdo->exec("CREATE TABLE IF NOT EXISTS projects (
            id INT AUTO_INCREMENT PRIMARY KEY,
            titre VARCHAR(100) NOT NULL,
            description VARCHAR(255) NOT NULL,
            objectif DECIMAL(10,2) NOT NULL,
            current_amount DECIMAL(10,2) NOT NULL DEFAULT 0,
            categorie VARCHAR(50) NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            end_date DATE NOT NULL,
            image VARCHAR(255) NOT NULL,
            id_users INT NOT NULL,
            vedette TINYINT(1) NOT NULL DEFAULT 0,
            statut VARCHAR(10) NOT NULL DEFAULT 'active',
            FOREIGN KEY (id_users) REFERENCES users(id)
        ) ENGINE=InnoDB");

        $pdo->exec("CREATE TABLE IF NOT EXISTS contributions (
            id INT AUTO_INCREMENT PRIMARY KEY,
            montant DECIMAL(10,2) NOT NULL,
            message TEXT,
            mode_payement Varchar (20) NOT NULL,
            telephone Varchar(13),
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            id_users INT NOT NULL,
            id_projects INT NOT NULL,
            FOREIGN KEY (id_users) REFERENCES users(id),
            FOREIGN KEY (id_projects) REFERENCES projects(id)
        ) ENGINE=InnoDB");

        $pdo->exec("CREATE TABLE IF NOT EXISTS messages(
            id       Int  Auto_increment  NOT NULL ,
            contenu  Varchar (255) NOT NULL ,
            dates    TimeStamp NOT NULL ,
            id_users Int NOT NULL COMMENT 'identifiant de l\'utilisateur' 
            ,CONSTRAINT messages_PK PRIMARY KEY (id)
            ,CONSTRAINT messages_users_FK FOREIGN KEY (id_users) REFERENCES users(id)
        )ENGINE=InnoDB");

        echo "Toutes les tables ont été créées avec succès.";
    } catch (PDOException $e) {
        die("Erreur : " . $e->getMessage());
    }
}

initializeDatabase();
?>