<?php
/**
 * Class ProjectsController
 * @author  ARSENE TEKEU
 * @version 1.0
 * @date    Mai 2025
 */
require_once __DIR__ . "/../config/database.php";
require_once __DIR__ . '/../models/Category.php';
require_once __DIR__ . "/../models/Projects.php";
require_once __DIR__ . "/../models/Contributions.php";


class ProjectsController
{
  
    /**
     * Afficher la liste des projets
     * Summary of index
     * @return void
     */
    public function index() {
        try {
            $category = $_GET['category'] ?? null;
            $id = $_GET['id'] ?? 0;
            $projects = Projects::getAll($category);
            $categories = Category::getAll();
            $categorie = null;
            
            if ($id > 0) {
                $categorie = Category::getById($id);
            }
            
            include __DIR__ . '/../views/project.php';
        } catch (Exception $e) {
            $_SESSION['error_message'] = $e->getMessage();
            $projects = [];
            $categories = Category::getAll();
            $categorie = null;
            include __DIR__ . '/../views/project.php';
        }
   
    }
    /**
     * Afficher les détails d'un projet
     * Summary of show
     * @return void
     */
    public function show()
    {
        $id = $_GET['id'] ?? 0;

        $project = new Projects();
        $projectDetails = $project->getProjectById($id);

        if (!$projectDetails) {
            $_SESSION['error_message'] = "Le projet demandé n'existe pas";
            header('Location: index.php');
            exit;
        }

        $contributions = Contributions::getContributionByProject($id);
        $contributionsCount = Contributions::getCountByProject($id);
        $averageContribution = Contributions::getAverageByProject($id);

        include __DIR__ . '/../views/project-details.php';
    }
    /**
     * Afficher le formulaire de création de projet
     */

    public function showCreateProjectForm()
    {
        $categories = Category::getAll();
        include __DIR__ . '/../views/create-project.php';
    }

    /**
     * Traiter la soumission du formulaire de création de projet
     * Summary of create
     * @return void
     */
    public function create()
    {
        if (!isset($_SESSION['user_id'])) {
            $_SESSION['error_message'] = "Vous devez être connecté pour créer un projet";
            header('Location: index.php?action=login');
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $titre = $_POST['titre'] ?? '';
            $description = $_POST['description'] ?? '';
            $objectif = floatval($_POST['objectif'] ?? 0);
            $end_date = $_POST['end_date'] ?? '';
            $categorie = $_POST['categorie'] ?? '';
            $id_users = $_SESSION['user_id'];
            $file = $_FILES['image'];
            $repertoire = "public/images/";

            $errors = [];

            if (empty($titre)) {
                $errors[] = "Le titre est requis";
            }
            if (strlen($titre) > 255) {
              $errors[] ="Titre trop longue !";
            }
            if (empty($description)) {
                $errors[] = "La description est requise";
            }
            if (strlen($description) > 255) {
              $errors[] ="Description trop longue !";
            }
            if ($objectif <= 0) {
                $errors[] = "L'objectif de financement doit être supérieur à zéro";
            }

            if (empty($end_date)) {
                $errors[] = "La date de fin est requise";
            } elseif (strtotime($end_date) <= time()) {
                $errors[] = "La date de fin doit être dans le futur";
            }

            if (empty($categorie)) {
                $errors[] = "La catégorie est requise";
            }

            if (empty($errors)) {
                $project = new Projects();
                $nomImage = $this->ajoutImage($file, $repertoire);
                $result = $project->createProject($titre, $description, $objectif, $categorie, $end_date, $nomImage, $id_users);
                if ($result) {
                    $_SESSION['success'] = "Votre projet a été créé avec succès";
                    header('Location: index.php?action=create_project');
                    exit;
                } else {
                    $errors[] = "Une erreur s'est produite lors de la création du projet";
                }
            }

            // S'il y a des erreurs, afficher le formulaire avec les erreurs
            $categories = Category::getAll();
            include __DIR__ . '/../views/create-project.php';
        } else {
            header('Location: index.php?action=create-project');
            exit;
        }
    }

    /**
     * Afficher le formulaire de modification d'un projet
     * @return void
     */
    public function edit()
    {
        if (!isset($_SESSION['user_id'])) {
            $_SESSION['error_message'] = "Vous devez être connecté pour modifier un projet";
            header('Location: index.php?action=login');
            exit;
        }

        $id = $_GET['id'] ?? 0;

        $project = new Projects();
        $projectDetails = $project->getProjectById($id);

        if (!$projectDetails) {
            $_SESSION['error_message'] = "Le projet demandé n'existe pas";
            header('Location: index.php');
            exit;
        }
        // Vérifier que l'utilisateur est le créateur du projet
        if ($projectDetails['id_users'] != $_SESSION['user_id']) {
            $_SESSION['error_message'] = "Vous n'êtes pas autorisé à modifier ce projet";
            header('Location: index.php');
            exit;
        }

        $categories = Category::getAll();
        include __DIR__ . '/../views/edit-projet.php';
    }

    /**
     * Traiter la soumission du formulaire de modification de projet
     * Summary of update
     * @return void
     */
    public function update()
    {
        if (!isset($_SESSION['user_id'])) {
            $_SESSION['error_message'] = "Vous devez être connecté pour modifier un projet";
            header('Location: index.php?action=login');
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $id = $_POST['id'] ?? 0;
            $titre = $_POST['titre'] ?? '';
            $description = $_POST['description'] ?? '';
            $objectif = floatval($_POST['objectif'] ?? 0);
            $end_date = $_POST['end_date'] ?? '';
            $categorie = $_POST['categorie'] ?? '';
            $file = $_FILES['image'];
            $id_users = $_POST['id_users'] ?? $_SESSION['user_id'];

            $project = new Projects();
            $projectDetails = $project->getProjectById($id);

            if (!$projectDetails) {
                $_SESSION['error_message'] = "Le projet demandé n'existe pas";
                header('Location: index.php');
                exit;
            }

            // Vérifier que l'utilisateur est le créateur du projet
            if ($projectDetails['id_users'] != $_SESSION['user_id']) {
                $_SESSION['error_message'] = "Vous n'êtes pas autorisé à modifier ce projet";
                header('Location: index.php');
                exit;
            }

            $errors = [];

            if (empty($titre)) {
                $errors[] = "Le titre est requis";
            }

            if (empty($description)) {
                $errors[] = "La description est requise";
            }

            if ($objectif <= 0) {
                $errors[] = "L'objectif de financement doit être supérieur à zéro";
            }

            if (empty($end_date)) {
                $errors[] = "La date de fin est requise";
            }

            if (empty($categorie)) {
                $errors[] = "La catégorie est requise";
            }
            if (empty($file))
                $errors[] = "l'image requis ";

            $imageActuelle = $projectDetails['image'];
            $file = $_FILES['image'];

            

            if (empty($errors)) {
                    if ($file['size'] > 0) {
                        unlink("public/images/" . $imageActuelle);
                        $repertoire = "public/images/";
                        $nomImageToAdd = $this->ajoutImage($file, $repertoire);// upload de l'image
                    } else {
                        $nomImageToAdd = $imageActuelle;
                    }
                $result = $project->updateProject($id, $titre, $description, $objectif, $categorie, $end_date, $nomImageToAdd, $id_users);

                if ($result) {
                    $_SESSION['success'] = "Votre projet a été mis à jour avec succès";
                    header('Location: index.php?action=project&id=' . $id);
                    exit;
                } else {
                    $errors[] = "Une erreur s'est produite lors de la mise à jour du projet";
                }
            }

            // S'il y a des erreurs, afficher le formulaire avec les erreurs
            $categories = Category::getAll();
            include __DIR__ . '/../views/edit-project.php';
        } else {
            header('Location: index.php');
            exit;
        }
    }

    // Supprimer un projet
    /**
     * Supprimer un projet
     * @return void
     */
    public function delete()
    {
        if (!isset($_SESSION['user_id'])) {
            header('Location: index.php?action=login');
            exit;
        }
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $csrfToken = $_POST['csrf_token'] ?? '';
            
            if (!hash_equals($_SESSION['csrf_token'], $csrfToken)) {
                die('Invalid CSRF token');
            }
            
            $projectId = $_POST['project_id'] ?? null;
            
            if (!$projectId) {
                $_SESSION['error_message'] = "ID du projet manquant.";
                header('Location: index.php?action=profile');
                exit;
            }
            
            $project = new Projects();
            $projectDetails = $project->getProjectById($projectId);
            
            if (!$projectDetails) {
                $_SESSION['error_message'] = "Projet non trouvé.";
                header('Location: index.php?action=profile');
                exit;
            }
            
            // Vérifier que l'utilisateur est le créateur du projet
            if ($projectDetails['id_users'] != $_SESSION['user_id']) {
                $_SESSION['error_message'] = "Vous n'êtes pas autorisé à supprimer ce projet.";
                header('Location: index.php?action=profile');
                exit;
            }
            
            // Supprimer d'abord les contributions associées au projet
            $contributions = new Contributions();
            $contributions->deleteByProject($projectId);
            
            $nomImage = $projectDetails['image']->getImage();
            unlink("public/images/" . $nomImage); //suppression de l'image dans public/images
            // Supprimer ensuite le projet
            $result = $project->deleteProject($projectId);
            
            if ($result) {
                $_SESSION['success_message'] = "Le projet a été supprimé avec succès.";
            } else {
                $_SESSION['error_message'] = "Une erreur s'est produite lors de la suppression du projet.";
            }
            
            header('Location: index.php?action=profile');
            exit;

        } else {
            $_SESSION['error_message'] = "Méthode de requête invalide.";
            header('Location: index.php?action=profile');
            exit;
        }
    }
    /**
     * Afficher les détails d'un projet
     * @param int $id L'ID du projet
     * @return void 
     */
    public function showProjectDetails(int $id)
    {
        $project = new Projects();
        $users = new User();
        $user = $users->getUserByIdProject($id);
        $projectDetails = $project->getProjectById($id);

        $contributions = Contributions::getContributionByProject($id);

        include __DIR__ . '/../views/project-details.php';
    }
    public function showCreateProjectDetails()
    {
        include __DIR__ . '/../views/create-project.php';
    }

    /**
     * Ajouter une image
     * @param $file le fichier image
     * @param $dir le repertoire de destination
     * @return string le nom de l'image
     * @throws Exception lorsque l'ajout de l'image échoue
     */

    private function ajoutImage($file, $dir)
    {
        if (!isset($file['name']) || empty($file['name'])) {
            throw new Exception("vous devez indiquez une image");
        }
        if (!file_exists($dir))
            mkdir($dir, 0777);

        $extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        $random = rand(0, 99999);
        $target_file = $dir . $random . "_" . $file['name'];

        if (!getimagesize($file["tmp_name"]))
            throw new Exception("le fichier n'est pas une image");
        if ($extension !== "jpg" && $extension !== "jpeg" && $extension !== "png" && $extension !== "gif")
            throw new Exception("l'extension du fichier n'est pas reconnu");
        if (file_exists($target_file))
            throw new Exception("le ficher existe deja");
        if ($file['size'] > (5 * 1024 * 1024))
            //la taille de ;'image ne doit pas depaaser 5 Mo
            throw new Exception("le fichier trop volumineux");
        if (!move_uploaded_file($file['tmp_name'], $target_file))
            throw new Exception("l'ajout de l'image n'a pas datesner");
        else
            return ($random . "_" . $file['name']);
    }
}



?>