<?php include 'templates/header.php'; $Pagetitle="Les projets";?>

    <!-- CSS personnalisé -->
    <style>
        /* Couleurs personnalisées */
        :root {
            --primary-color: #18b7b7;
            --dark-footer: #1c1c1c;
        }
        /* Navigation */
        .navbar-brand {
            font-weight: 600;
            color: var(--primary-color) !important;
        }
        .nav-link {
            color: #ffffff;
            margin: 0 10px;
        }
        /* Header avec image de fond */
        .hero-header {
            background-image: url('https://images.unsplash.com/photo-1488521787991-ed7bbaae773c?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=1950&q=80');
            background-size: cover;
            background-position: center;
            position: relative;
            min-height: 450px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            color: white;
            text-align: center;
            padding-top: 40px;
            padding-bottom: 40px;
        }
        /* Overlay sur l'image de fond */
        .hero-header::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.4);
            z-index: 1;
        }
        .hero-content {
            position: relative;
            z-index: 2;
        }
        .hero-title {
            font-size: 2.8rem;
            margin-bottom: 0.5rem;
            font-weight: 300;
        }
        .hero-subtitle {
            font-size: 2.5rem;
            font-weight: 600;
            color: var(--primary-color);
            margin-bottom: 2rem;
        }
        .btn-custom {
            background-color: none;
            color: #ffffff;
            border: 1px solid white;
            border-radius: 45px;
            padding: 10px 25px;
            transition: all 0.3s ease;
        }

        /* Alerte sous le header */
        .alert {
            background-color: white;
            text-align: center;
            padding: 20px;
            font-size: 1.2rem;
            font-weight: 500;
        }

        .underline {
            text-decoration: underline var(--primary-color);
            text-decoration-thickness: 3px;
        }

        /* Barre de recherche */
        .search-bar {
            position: relative;
        }
        .search-bar .form-control {
            padding: 12px 20px;
            background-color: #f5f5f5;
            border: none;
        }
        .search-bar .btn {
            height: 100%;
            border-radius: 0 25px 25px 0;
        }
        /* Filtres de catégories */
        .category-filters {
            margin: 20px 0;
        }
        .btn-category {
            border-radius: 25px;
            padding: 7px 15px;
            margin: 5px;
            color: #333;
            background-color: #f5f5f5;
            border: none;
            transition: all 0.3s ease;
        }

        .btn-category:hover,
        .btn-category.active {
            background-color: var(--primary-color);
            color: white;
        }

        /* Cartes de projet */
        .project-card {
            border: none;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        .project-card .card-img-top {
            height: 200px;
            object-fit: cover;
        }
        .project-date-donations {
            display: flex;
            justify-content: space-between;
            color: #666;
            font-size: 0.8rem;
            margin-bottom: 10px;
        }
        .project-donations {
            color: var(--primary-color);
            font-weight: 500;
        }
        .card-title {
            font-weight: 600;
            margin-bottom: 10px;
        }
        .btn-save {
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 8px 12px;
            color: #666;
            background: transparent;
        }
        .btn-donate {
            background-color: var(--primary-color);
            color: white;
            border-radius: 5px;
            padding: 8px 15px;
            transition: all 0.3s ease;
        }
        
        .btn-donate:hover {
            background-color: #0e9a9a;
            color: white;
        }
        
        /* Footer */
        footer {
            background-color: var(--dark-footer) !important;
        }
        
        footer h5 {
            color: white;
            font-weight: 500;
        }
        
        footer .text-primary {
            color: var(--primary-color) !important;
        }
    </style>

    <!-- Hero Header avec image de fond -->
    <header class="hero-header">
        <div class="container hero-content">
            <h1 class="hero-title fw-bold" style="opacity: 60; margin-right:10%;">Un petit geste</h1>
            <h2 class="hero-subtitle fw-bold" style="margin-left:20%">Un grand impact</h2>
            <?php if (isset($_SESSION['user_id'])): ?>
                <a href="index.php?action=create_project" class="btn btn-custom">Lancer votre collecte</a>
            <?php else: ?>
            <a href="index.php?action=register" class="btn btn-custom">Créer un compte</a>
            <?php endif; ?>
        </div>
    </header>

    <!-- Bannière d'alerte -->
    <div class="alert">
        <div class="container fw-bold">
            <span class="underline">Presque au but</span>! Aidez-les à réunir les derniers fonds qu'il leur manque.
        </div>
    </div>

    <!-- Barre de recherche -->
    <div class="container mt-4 mb-3">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="input-group search-bar">
                    <input type="text" class="form-control rounded-pill" placeholder="Rechercher des dons......"
                        aria-label="Search">
                    <button class="btn position-absolute end-0 bg-transparent" type="button">
                        <i class="bi bi-search"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtres de catégories -->
    <div class="container mb-4">
        <div class="row justify-content-center">
            <div class="col-md-10 text-center">
                <div class="category-filters">
                    <a href="index.php?action=projects&category" class="btn btn-category active" title="Tous les Catégories">Tout</a>
                    <?php foreach ($categories as $category): ?>
                        <a href="index.php?action=projects&category=<?php echo urlencode($category['nom']); ?>&id=<?php echo urlencode($category['id']); ?>"
                            class="btn btn-category"
                            title="Catégorie <?php echo htmlspecialchars($category['nom']); ?>"><?php echo htmlspecialchars($category['nom']); ?></a>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Grille de projets -->
    <div class="container projects-container mb-5">
        <div class="row">
            <?php if (count($projects) <= 0): ?>
                <div class="col-md-3"></div>
                <div class="col-md-6">
                    <?php if ($categorie): ?>
                        Aucun project de la Catégorie <span class="fw-bold"><?= htmlspecialchars($categorie['nom']) ?></span> disponible
                    <?php else: ?>
                        Aucun projet disponible
                    <?php endif; ?>
                </div>
                <div class="col-md-3"></div>
            <?php else: ?>
                <?php foreach ($projects as $project): ?>
                    <div class="col-md-4 mb-4">
                        <div class="card project-card">
                            <img src="/public/images/<?php echo htmlspecialchars($project['image']); ?>"
                                alt="<?php echo htmlspecialchars(substr($project['titre'],0,50)); ?>" class="card-img-top">
                            <div class="card-body">
                                <div class="project-date-donations">
                                    <span class="project-date"><?= date('d/m/Y', strtotime($project['created_at'])) ?></span>
                                    <span class="project-donations"> <?= htmlspecialchars($project['nombre_donateurs']) ?> donations</span>
                                </div>
                                <h5 class="card-title"><?= htmlspecialchars(substr($project['titre'],0,50)) ?>...</h5>
                                <p class="card-text"><?= htmlspecialchars(substr($project['description'],0,50)) ?>...</p>
                                <div class="d-flex justify-content-between align-items-center mt-3">
                                    <button class="btn btn-save">
                                        <a href="index.php?action=project&id=<?= $project['id'] ?>"><i class="far fa-bookmark" title="voir les details du projet"></i></a>
                                    </button>
                                    <?php if ($project['total_contribuer'] >= $project['objectif']): ?>
                                        <a href="#" class="btn btn-donate">Faire un don maintenant</a>
                                    <?php else: ?>
                                        <a href="index.php?action=contribute&id=<?= $project['id'] ?>" class="btn btn-donate">
                                            Faire un don maintenant
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>

    <!-- Bouton voir plus -->
    <div class="text-center mt-3">
        <a href="#" class="btn btn-outline-primary rounded-pill px-4">voir plus</a>
    </div>

<style>
    .project-card {
        /* Force une hauteur minimale pour toutes les cartes */
        min-height: 450px;
        transition: transform 0.3s ease;
    }

    .card-img-top {
        height: 200px;
        object-fit: cover;
    }

    .card-title {
        min-height: 50px;
        display: flex;
        align-items: center;
    }

    .card-text {
        min-height: 80px;
    }
</style>

<?php include 'templates/footer.php'; ?>
